/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.components;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.component.PlayerOriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.forge.ModComponentsArchitecturyImpl;
import java.util.Comparator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgePlayerOriginComponent
extends PlayerOriginComponent
implements ICapabilityProvider,
ICapabilitySerializable<INBT>,
IItemHandlerModifiable {
    private IItemHandlerModifiable wrapper = new CombinedInvWrapper(new IItemHandlerModifiable[0]);
    private final transient LazyOptional<OriginComponent> thisOptional = LazyOptional.of(() -> this);
    private final transient LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this);

    public ForgePlayerOriginComponent(PlayerEntity player) {
        super(player);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        LazyOptional opt = ModComponentsArchitecturyImpl.ORIGIN_COMPONENT_CAPABILITY.orEmpty(capability, this.thisOptional);
        if (opt.isPresent()) {
            return opt;
        }
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.itemHandler);
    }

    public INBT serializeNBT() {
        return ModComponentsArchitecturyImpl.ORIGIN_COMPONENT_CAPABILITY.writeNBT((Object)this, null);
    }

    public void deserializeNBT(INBT arg) {
        ModComponentsArchitecturyImpl.ORIGIN_COMPONENT_CAPABILITY.readNBT((Object)this, null, arg);
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        boolean hasChanged = this.getOrigin(layer) != origin;
        super.setOrigin(layer, origin);
        if (hasChanged) {
            this.rebuildCache();
        }
    }

    private void rebuildCache() {
        IItemHandlerModifiable[] invPowers = (IItemHandlerModifiable[])this.getPowers().stream().filter(x -> x instanceof IInventory).sorted(Comparator.comparing(x -> x.getType().getIdentifier())).map(IInventory.class::cast).map(InvWrapper::new).toArray(IItemHandlerModifiable[]::new);
        this.wrapper = new CombinedInvWrapper(invPowers);
    }

    public void setStackInSlot(int i, @NotNull ItemStack arg) {
        this.wrapper.setStackInSlot(i, arg);
    }

    public int getSlots() {
        return this.wrapper.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return this.wrapper.getStackInSlot(i);
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack arg, boolean bl) {
        return this.wrapper.insertItem(i, arg, bl);
    }

    @NotNull
    public ItemStack extractItem(int i, int j, boolean bl) {
        return this.wrapper.extractItem(i, j, bl);
    }

    public int getSlotLimit(int i) {
        return this.wrapper.getSlotLimit(i);
    }

    public boolean isItemValid(int i, @NotNull ItemStack arg) {
        return this.wrapper.isItemValid(i, arg);
    }
}

